﻿namespace Code6587EN.Ch06.NewMetadataApp
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;
    using System.Reflection;
    using System.Security.Principal;
    using System.Linq;

    /// <summary>
    /// Console Application to create a new Managed Metadata Service Application
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Get the managed account for the application pool
            var account = new NTAccount("westeros\\sp_services");
            var processAccount = SPProcessAccount.LookupManagedAccount((SecurityIdentifier)account.Translate(typeof(SecurityIdentifier)));

            // Get the types used to instantiate an application pool
            var appPoolType = Type.GetType("Microsoft.SharePoint.Administration.SPIisWebServiceApplicationPool, Microsoft.SharePoint, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");
            var appPoolOptionsType = Type.GetType("Microsoft.SharePoint.Administration.SPIisWebServiceApplicationPoolProvisioningOptions, Microsoft.SharePoint, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");
            var noneOption = appPoolOptionsType.GetField("None").GetValue(appPoolOptionsType);

            // Use the Create and BeginProvision methods to create the application pool
            var name = "Managed Metadata Service Application Pool";
            var createMethod = appPoolType.GetMethod("Create", BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Static, null, new Type[] { typeof(SPFarm), typeof(string), typeof(SPProcessAccount) }, null);
            var applicationPool = (SPIisWebServiceApplicationPool)createMethod.Invoke(null, new object[] { SPFarm.Local, name, processAccount });
            applicationPool.Update();
            var beginProvision = appPoolType.GetMethod("BeginProvision", BindingFlags.Instance | BindingFlags.NonPublic);
            beginProvision.Invoke(applicationPool, new object[] { noneOption });

            // Get the type used to instantiate the managed metadata service application
            var metadataAppType = Type.GetType("Microsoft.SharePoint.Taxonomy.MetadataWebServiceApplication, Microsoft.SharePoint.Taxonomy, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");

            // Use the Create method to create a new managed metadata service application
            var createAppMethod = metadataAppType.GetMethod("Create", BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Static, null, new Type[] { typeof(String), typeof(String), typeof(String), typeof(String), typeof(String), typeof(String), typeof(SPIisWebServiceApplicationPool), typeof(String), typeof(bool), typeof(bool), typeof(bool), typeof(int), typeof(int), typeof(bool) }, null);
            var mms = createAppMethod.Invoke(null, new object[] { 
                "Managed Metadata Service",
                "ManagedMetadataDatabase",
                null,
                null,
                null,
                null,
                applicationPool,
                null,
                false,
                false,
                false,
                0,
                0,
                false
            });

            // Get the managed metadata service application Uri property
            var mmsUri = (Uri)metadataAppType.GetProperty("Uri", BindingFlags.Instance | BindingFlags.Public).GetValue(mms);

            // Get the type used to instantiate the managed metadata service application proxy
            var metadataProxyAppType = Type.GetType("Microsoft.SharePoint.Taxonomy.MetadataWebServiceApplicationProxy, Microsoft.SharePoint.Taxonomy, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c");

            // Use the CreateProxy method to create a new service application proxy
            var createProxyMethod = metadataProxyAppType.GetMethod("CreateProxy", BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Static, null, new Type[] { typeof(Uri), typeof(string), typeof(bool), typeof(bool), typeof(bool), typeof(Uri), typeof(bool), typeof(bool), typeof(bool) }, null);
            createProxyMethod.Invoke(null, new object[] { 
                mmsUri, // Uri for the service application
                "Managed Metadata Service Proxy", // Name of the proxy
                false, // Default proxy for keywords
                false, // Default proxy for site collection taxonomy
                false, // Content type syndication enabled
                null, // Uri for the site collection metadata hub
                false, // Content type pushdown enabled
                true, // Add to the default proxy group
                false // Use partitioning
            });

            // Start the Managed Metadata Web Service on the local SharePoint server
            ((SPServiceInstance)SPServer.Local.ServiceInstances.Where(p => p.TypeName.Equals("Managed Metadata Web Service", StringComparison.OrdinalIgnoreCase)).First()).Provision();

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
